/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;

public class BeeBreedingRecipeCategory
implements IRecipeCategory<BeeBreedingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public BeeBreedingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_breeding_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)BeeIngredientFactory.getOrCreateList().get("productivebees:quarry_bee"));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_BEE_BREEDING_UID;
    }

    @Nonnull
    public Class<? extends BeeBreedingRecipe> getRecipeClass() {
        return BeeBreedingRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.bee_breeding");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BeeBreedingRecipe recipe, List<? extends IFocus<?>> focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 12, 17).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)((BeeIngredient)recipe.ingredients.get(0).get()))).setSlotName("parent1");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 46, 17).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)((BeeIngredient)recipe.ingredients.get(1).get()))).setSlotName("parent2");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 104, 17).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)((BeeIngredient)recipe.offspring.get()))).setSlotName("offspring");
        ArrayList<List<ItemStack>> breedingItems = new ArrayList<List<ItemStack>>();
        for (Lazy<BeeIngredient> ingredient : recipe.ingredients) {
            BeeIngredient beeIngredient = (BeeIngredient)ingredient.get();
            Entity bee = beeIngredient.getCachedEntity(ProductiveBees.proxy.getWorld());
            if (bee instanceof ProductiveBee) {
                ProductiveBee productiveBee = (ProductiveBee)bee;
                breedingItems.add(productiveBee.getBreedingItems());
                continue;
            }
            breedingItems.add(List.of(ItemStack.f_41583_));
        }
        if (breedingItems.size() == 2) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 38).addItemStacks((List)breedingItems.get(0))).setSlotName("breedingItem1");
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 44, 38).addItemStacks((List)breedingItems.get(1))).setSlotName("breedingItem2");
        }
    }
}

